/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.csg;

import com.brandon3055.csg.lib.PlayerSlot;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.Closeable;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataManager {
    private static Logger LOGGER = LogManager.getLogger();
    private static Path configFile;
    public static Map<PlayerSlot, CompoundNBT> spawnInventory;
    public static Map<String, Map<PlayerSlot, CompoundNBT>> kits;
    public static List<String> wipeBlacklist;

    public static void initialize() {
        configFile = Paths.get("./config/brandon3055/CSG/Config.json", new String[0]);
        if (!configFile.toFile().getParentFile().exists()) {
            configFile.toFile().getParentFile().mkdirs();
        }
        try {
            DataManager.loadConfig();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void saveConfig() throws IOException {
        if (spawnInventory == null) {
            LOGGER.error("Could not save config because inventory array was null!");
            return;
        }
        JsonObject obj = new JsonObject();
        JsonObject inv = new JsonObject();
        spawnInventory.forEach((playerSlot, stack) -> inv.addProperty(playerSlot.toString(), stack.toString()));
        obj.add("inventory", (JsonElement)inv);
        if (kits.size() > 0) {
            JsonObject kitsObj = new JsonObject();
            kits.forEach((name, kit) -> {
                JsonObject kitObj = new JsonObject();
                kit.forEach((playerSlot, stack) -> kitObj.addProperty(playerSlot.toString(), stack.toString()));
                kitsObj.add(name, (JsonElement)kitObj);
            });
            obj.add("kits", (JsonElement)kitsObj);
        }
        JsonArray blacklist = new JsonArray();
        wipeBlacklist.forEach(arg_0 -> ((JsonArray)blacklist).add(arg_0));
        obj.add("wipeBlacklist", (JsonElement)blacklist);
        JsonWriter writer = new JsonWriter((Writer)new FileWriter(configFile.toFile()));
        writer.setIndent("  ");
        Streams.write((JsonElement)obj, (JsonWriter)writer);
        writer.flush();
        IOUtils.closeQuietly((Closeable)writer);
    }

    public static void loadConfig() throws IOException, CommandSyntaxException {
        if (!configFile.toFile().exists()) {
            spawnInventory = null;
            LOGGER.warn("Custom Spawn Inventory has not been configured yet! Canceling config load!");
            return;
        }
        JsonParser parser = new JsonParser();
        FileReader reader = new FileReader(configFile.toFile());
        JsonElement element = parser.parse((Reader)reader);
        IOUtils.closeQuietly((Reader)reader);
        if (!element.isJsonObject()) {
            LOGGER.warn("Detected invalid config json! Canceling config load!");
            return;
        }
        JsonObject obj = element.getAsJsonObject();
        if (obj.has("inventory") && obj.get("inventory").isJsonObject()) {
            LOGGER.info("Reading starting inventory config");
            spawnInventory = new HashMap<PlayerSlot, CompoundNBT>();
            JsonObject inv = obj.get("inventory").getAsJsonObject();
            for (Map.Entry entry : inv.entrySet()) {
                PlayerSlot slot = PlayerSlot.fromString((String)entry.getKey());
                CompoundNBT stack = JsonToNBT.func_180713_a((String)((JsonElement)entry.getValue()).getAsJsonPrimitive().getAsString());
                spawnInventory.put(slot, stack);
            }
            LOGGER.info("Loaded " + spawnInventory.size() + " starting items.");
        }
        if (obj.has("kits") && obj.get("kits").isJsonObject()) {
            LOGGER.info("Reading kits from config");
            JsonObject kits = obj.get("kits").getAsJsonObject();
            for (Map.Entry entry : kits.entrySet()) {
                String name = (String)entry.getKey();
                JsonObject items = ((JsonElement)entry.getValue()).getAsJsonObject();
                Map kitMap = DataManager.kits.computeIfAbsent(name, s -> new HashMap());
                for (Map.Entry kitEntry : items.entrySet()) {
                    PlayerSlot slot = PlayerSlot.fromString((String)kitEntry.getKey());
                    CompoundNBT stack = JsonToNBT.func_180713_a((String)((JsonElement)kitEntry.getValue()).getAsJsonPrimitive().getAsString());
                    kitMap.put(slot, stack);
                }
                LOGGER.info("Loaded " + kitMap.size() + " items for kit " + name);
            }
        }
        if (obj.has("wipeBlacklist") && obj.get("wipeBlacklist").isJsonArray()) {
            wipeBlacklist.clear();
            obj.get("wipeBlacklist").getAsJsonArray().forEach(e -> wipeBlacklist.add(e.getAsString()));
        }
    }

    public static void givePlayerStartGear(PlayerEntity player) {
        if (spawnInventory == null) {
            player.func_145747_a((ITextComponent)new StringTextComponent("Custom Starting Gear has not been configured!").func_240699_a_(TextFormatting.DARK_RED), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)new StringTextComponent("If you are an operator use /csg_config to get more info."), Util.field_240973_b_);
            return;
        }
        if (wipeBlacklist.isEmpty()) {
            player.field_71071_by.func_174888_l();
        } else {
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b() || wipeBlacklist.contains(stack.func_77973_b().getRegistryName().func_110624_b()) || wipeBlacklist.contains(stack.func_77973_b().getRegistryName().toString())) continue;
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
        }
        for (PlayerSlot slot : spawnInventory.keySet()) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)spawnInventory.get(slot).func_74737_b());
            if (slot.getStackInSlot(player).func_190926_b()) {
                slot.setStackInSlot(player, stack);
                continue;
            }
            ItemEntity entity = (ItemEntity)EntityType.field_200765_E.func_200721_a(player.field_70170_p);
            if (entity == null || player.field_70170_p.field_72995_K) continue;
            entity.func_92058_a(stack);
            entity.func_174868_q();
            entity.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            player.field_70170_p.func_217376_c((Entity)entity);
        }
    }

    public static void givePlayerKit(PlayerEntity player, String kit) {
        if (!kits.containsKey(kit)) {
            player.func_145747_a((ITextComponent)new StringTextComponent("The requested kit \"" + kit + "\" does not exist!").func_240699_a_(TextFormatting.DARK_RED), Util.field_240973_b_);
            return;
        }
        Map<PlayerSlot, CompoundNBT> kitItems = kits.get(kit);
        player.field_71071_by.func_174888_l();
        for (PlayerSlot slot : kitItems.keySet()) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)kitItems.get(slot).func_74737_b());
            slot.setStackInSlot(player, stack);
        }
    }

    static {
        spawnInventory = null;
        kits = new LinkedHashMap<String, Map<PlayerSlot, CompoundNBT>>();
        wipeBlacklist = new ArrayList<String>();
    }
}

